/**
 * Beschrijft het gedrag van een ridder in een computergame.
 * 
 * @author Dominiek Vandewalle
 * @version 2015-06-28
 */
public class Ridder
{
    //velden
    private String naam;
    private int aantalLevens;
    private boolean heeftSchild;
    
    /**
     * Constructor voor objecten van de klasse Ridder.
     * Ridders worden geboren met drie levens en dragen geen schild.
     * @param   naam    de naam van ridder
     */
    public Ridder(String naam)
    {
        this.naam = naam;
        aantalLevens = 3;
        heeftSchild = false;
    }
    
    /**
     * Geeft de naam van de ridder terug.
     * @return     De naam van de ridder. 
     */
    public String getNaam()
    {
        return naam;
    }
    
    /**
     * Geeft het aantal levens van de ridder terug.
     * @return     Het aantal levens van de ridder.
     */
    public int getAantalLevens()
    {
        return aantalLevens;
    }
    
    /**
     * Geeft aan of de ridder al dan niet dood is.
     * @return     True indien de ridder dood is, anders false.
     */
    private boolean isDood()
    {
        boolean isDood;
        
        if (aantalLevens == 0)
        {
            isDood = true;
        }
        else
        {
            isDood = false;
        }
        
        return isDood;
    }
    
    /**
     * Indien de ridder zonder schild geraakt wordt, gaat 1 leven verloren.
     * Indien de ridder met schild geraakt wordt, gaat het schild verloren.
     */
    public void doorZwaardGeraakt()
    {
        if(aantalLevens > 0 && heeftSchild == false)
        {
            aantalLevens--;
        }
        
        if(heeftSchild == true)
        {
            heeftSchild = false;
        }
    }
    
    /**
     * De ridder neemt een schild van het speelveld op.
     */
    public void raapSchildOp()
    {
        if(! (aantalLevens == 0))
        {
            heeftSchild = true;
        }
    }
    
    
    /**
     * Toont de strijdkreet van de ridder in het terminalvenster
     */
    public void strijdkreet()
    {
        String boodschap = "";
        
        if(aantalLevens > 10)
        {
            boodschap = "Alles voor mijn prinses!";
        }
        else if(aantalLevens > 5)
        {
            boodschap = "Kom maar op, ik kan je aan!";
        }
        else if(aantalLevens >= 3 && heeftSchild)
        {
            boodschap = "Ik hou stand!";
        }
        else
        {
            boodschap = "Ik geef mijn leven voor de prinses!";
        }
        
        System.out.println(boodschap);
    }
    
     /**
     * Bepaalde ridders kunnen uit de dood herleven.
     */
    public void herleef()
    {
        if(isDood())
        {
            switch(naam)
            {
                case "Richard the Lionheart":
                case "Joan of Arc":
                    aantalLevens = 3;
                    break;
                case "Blackadder":
                    aantalLevens = 2;
                    break;
                default:
                    aantalLevens = 1;
                    break;
            }
        }
    } 
}